 uses sysutils;
 
 type pdword = ^integer;
 
 var
  forth_eax, forth_esi, forth_edi, pas_ebx, pas_edi: integer;
  s: string;
  forth_st0: extended;

 procedure retroforth_eval; external 'rf.dll' name 'retroforth_eval';
 procedure retroforth_init; external 'rf.dll' name 'retroforth_init';

function IntToHex(Value: Integer): string; //stdcall;
 const
  a: string = '0123456789abcdef';
 begin
  Result := '00000000';
  Result[1] := a[(Value shr 28) and $f + 1];
  Result[2] := a[(Value shr 24) and $f + 1];
  Result[3] := a[(Value shr 20) and $f + 1];
  Result[4] := a[(Value shr 16) and $f + 1];
  Result[5] := a[(Value shr 12) and $f + 1];
  Result[6] := a[(Value shr 8) and $f + 1];
  Result[7] := a[(Value shr 4) and $f + 1];
  Result[8] := a[(Value shr 0) and $f + 1];
 end;

procedure reg2pas; assembler;
 asm
  mov [forth_eax], eax
  mov [forth_esi], esi
  mov [forth_edi], edi
  fstp tbyte ptr [forth_st0]
  mov ebx, [pas_ebx]
  mov edi, [pas_edi]
 end;

procedure reg2forth; assembler;
 asm
  mov [pas_ebx], ebx
  mov [pas_edi], edi
  mov eax, [forth_eax]
  mov esi, [forth_esi]
  mov edi, [forth_edi]
  fld tbyte ptr [forth_st0]
 end;

procedure dup;
 begin
  forth_esi:=forth_esi-4;
  pdword(forth_esi)^:=forth_eax;
 end;

procedure drop;
 begin
  forth_eax:=pdword(forth_esi)^;
  forth_esi:=forth_esi+4;
 end;

procedure push(value: integer);
 begin
  dup;
  forth_eax:=value;
 end;

function Pop: Integer;
 begin
  pop:=forth_eax;
  drop;
 end; 

procedure init;
 asm
  call reg2forth
  call retroforth_init
  call reg2pas
 end;

procedure Eval_mem(p: pointer; len: integer);
 begin
  push(integer(p));
  push(len);
  asm
   call reg2forth
   call retroforth_eval
   call reg2pas
  end;
 end;

procedure Eval_string(const Value: string);
 var a: pointer;
 begin
  a:=pointer(integer(@value)+1);
  eval_mem(a, length(value));
 end;

procedure Bind(const Name: string; Proc: Pointer); //stdcall;
 begin
  eval_string(' : ' + Name + ' [ $' + IntToHex(Integer(Proc)) + ' compile ] ;');
 end;

procedure vectorize(const Name: string; Proc: Pointer); //stdcall;
 begin
  eval_string('32 parse '+name+' find'); //  -   
  asm
   mov eax, [proc]
   sub eax, [forth_eax]
   mov edx, [forth_eax]
   sub eax, 5
   mov byte ptr [edx], $e8   // call
   mov [edx+1], eax          // address
   mov byte ptr [edx+5], $c3 //ret
   mov esi, [forth_esi] //2drop
   add esi, 8
   mov eax, [esi]
   mov [forth_esi], esi
   mov [forth_eax], eax
  end;
 end;

procedure pas_emit;
 var a: char;
 begin
  asm
   mov a, al
   lodsd
   call reg2pas
  end;
  write(a);
  asm
   call reg2forth
  end;
 end;

procedure Pas_Type;
 var
  s: string; i, k: integer; p: pointer;
 begin
  asm
   mov dword ptr [i], eax
   lodsd
   mov p, eax
   call reg2pas
  end;
  while i>0 do begin
   if i<255 then k:=i else k:=255;
   i:=i-k;
   s[0]:=char(k);
   Move(p^, s[1], Length(s));
   p:=pointer(integer(p)+k);
   write(s);
  end;
  asm
   call reg2forth
   lodsd
  end;
 end;

function _tofloat(s: string; var v: extended): boolean;
 begin
  _tofloat:=true;
  try
   v:=strtofloat(s);
  except
   on econverTerror do begin
    _tofloat:=false;
   end;
  else
   writeln('invalid exception during strtofloat!!');
  end;
 end;

procedure f10number;
 var v: extended; p: pointer; s: string;
 begin
  asm
   mov byte ptr [s], al
   lodsd
   mov p, eax
   lodsd
   call reg2pas
  end;
  Move(p^, s[1], Length(s));
  if _tofloat(s, v) then begin
   asm
    call reg2forth
    sub edi, 10
    fstp tbyte [edi] //fpush v
    fld tbyte [v]
    clc
   end;
  end else begin
   push(integer(p));
   push(integer(length(s)));
   asm
    call reg2forth
    stc
   end;
  end;
 end;

procedure f8number;
 var v: extended; p: pointer; s: string;
 begin
  asm
   mov byte ptr [s], al
   lodsd
   mov p, eax
   lodsd
   call reg2pas
  end;
  Move(p^, s[1], Length(s));
  if _tofloat(s, v) then begin
   asm
    call reg2forth
    sub edi, 8
    fstp qword [edi] //fpush v
    fld tbyte [v]
    clc
   end;
  end else begin
   push(integer(p));
   push(integer(length(s)));
   asm
    call reg2forth
    stc
   end;
  end;
 end;

procedure f4number;
 var v: extended; p: pointer; s: string;
 begin
  asm
   mov byte ptr [s], al
   lodsd
   mov p, eax
   lodsd
   call reg2pas
  end;
  Move(p^, s[1], Length(s));
  if _tofloat(s, v) then begin
   asm
    call reg2forth
    sub edi, 4
    fstp dword [edi] //fpush v
    fld tbyte [v]
    clc
   end;
  end else begin
   push(integer(p));
   push(integer(length(s)));
   asm
    call reg2forth
    stc
   end;
  end;
 end;

procedure f10type;
 var v: extended;
 begin
  asm
   fstp tbyte ptr [v]
   fld tbyte ptr [edi]
   add edi, 10
  end;
  reg2pas;
  write(v, ' ');
  reg2forth;
 end;

procedure f8type;
 var v: extended;
 begin
  asm
   fstp tbyte ptr [v]
   fld qword ptr [edi]
   add edi, 8
  end;
  reg2pas;
  write(v, ' ');
  reg2forth;
 end;

procedure f4type;
 var v: extended;
 begin
  asm
   fstp tbyte ptr [v]
   fld dword ptr [edi]
   add edi, 4
  end;
  reg2pas;
  write(v, ' ');
  reg2forth;
 end;

function use_file(filename: string): boolean;
 var f: file; p: pointer; s: integer;
 begin
  if fileexists(filename) then begin
   assign(f, filename);
   reset(f, 1);
   s:=filesize(f);
   getmem(p, s);
   blockread(f, p^, s);
   close(f);
   eval_mem(p, s);
   freemem(p);
   use_file:=true;
  end else use_file:=false;
 end;

procedure forth_uses;
 var s: string; p: pointer;
 begin
  asm
   mov byte ptr [s], al
   lodsd
   mov p, eax
   call reg2pas
  end;
  Move(p^, s[1], Length(s));
  if not use_file(s) then writeln('WARNING!! File "', s, '" not found!!');
  asm
   call reg2forth
   lodsd
  end;
 end;

begin
 init;
 eval_string('forth');
 vectorize('emit', @pas_emit);
 vectorize('type', @pas_type);
 vectorize('>float', @f10number);
 bind('>float10', @f10number);
 bind('>float8', @f8number);
 bind('>float4', @f4number);
 bind('f.', @f10type);
 bind('f10.', @f10type);
 bind('f8.', @f8type);
 bind('f4.', @f4type);
 bind('uses', @forth_uses);
 decimalseparator:='.';
 eval_string(': decimalseparator $'+inttohex(integer(@decimalseparator))+' ;');
 eval_string(': uses" ''" parse uses ;');
 eval_string('uses" system.f"');
 s:='';
 while s<>'bye' do begin
  eval_string(s);
  readln(s);
 end;
end.
